// -----------------------------------------------------------------------------------------
//                      C O L O R S
//------------------------------------------------------------------------------------------ 

#declare C_clear  =         rgbt 1 ;
#declare C_white =          color rgb <1,1,1>  ;
#declare C_black =          color rgb <0,0,0>  ;
#declare C_gray_dark =      color rgb <0.07,0.07,0.07> ;
#declare C_gray_black =     color rgb <0.03,0.03,0.03>  ;
#declare C_red =            color rgb <1,0,0>  ;  
#declare C_red_dark =       color rgb <.5,0,0>  ; 
#declare C_maroon =         color rgb <.45,.02,.02>  ;
#declare C_green =          color rgb <0,1,0>  ;  
#declare C_yellow =         color rgb <1,.9,0>  ;
#declare C_blue =           color rgb <0,.5,.9>  ;
#declare C_copper =         color rgb <0.40, 0.20, 0.15>;  
#declare C_gray5 =          color red 0.05 green 0.05 blue 0.05;
#declare C_gray10 =         color red 0.1 green 0.1 blue 0.1;   
#declare C_gray20 =         color red 0.2 green 0.2 blue 0.2;
#declare C_gray30 =         color red 0.3 green 0.3 blue 0.3; 
#declare C_gray40 =         color red 0.4 green 0.4 blue 0.4;
#declare C_gray50 =         color red 0.5 green 0.5 blue 0.5;
#declare C_gray60 =         color red 0.6 green 0.6 blue 0.6; 
#declare C_gray70 =         color red 0.7 green 0.7 blue 0.7;   
#declare C_gray80 =         color red 0.8 green 0.8 blue 0.8; 
#declare C_gray90 =         color red 0.9 green 0.9 blue 0.9;
#declare C_rust_red =       color rgb <0.6, 0.3, 0.25> ;
#declare C_rust_red_film =  color rgbt <0.6, 0.3, 0.25,.5> ;
#declare C_rust_gray =      color rgb <0.80, 0.80, 0.85> ;
#declare C_rust_gray_dark = color rgb <0.70, 0.70, 0.80>  ; 
#declare C_galvanize1 =     color rgb <0.90, 0.90, 0.95> ;
#declare C_galvanize2 =     color rgb <0.80, 0.80, 0.85>  ;
#declare C_breaker_black =  color rgb <0.15,.15,.17> *.3 ;
#declare C_panel_gray =     color rgb <0.15,.15,.17> * 2 ;
#declare C_gray_blue =      color red 0.8 green 0.8 blue 0.9 ;
#declare C_tan =            color red 0.85 green 0.66 blue 0.5;
#declare C_tan_dark =       color red 0.66 green 0.5 blue 0.4;
#declare C_orange =         color rgb <1,1,0>  ;
#declare C_copper =         color rgb <0.40, 0.20, 0.15>;  
#declare C_silver =         color rgb <0.85, 0.85, 0.8>;   
#declare C_gold =           color red 0.82 green 0.6 blue 0.196078;
#declare C_gold_bright=     color rgb <0.90, 0.65, 0.15>;
#declare C_light_blue =     color red 0.6 green 0.8 blue 1; 
#declare C_horizon_blue =   color red .82 green 1 blue .98; 
#declare C_blue_charcoal =  color rgb <.07,.09,.18> ;
#declare C_yellow_dull  =   color rgb <1,.9,.10>  ;
#declare C_sea_green =      color rgb <.4,1,.6> ;
#declare f = .0039  ;                             
#declare tR = 107*f ;
#declare tG = 176*f ;
#declare tB = 189*f ;
#declare C_teal = color rgb<tR,tG,tB> ;
#declare C_red50 = rgbf<1,0,0,.5>;



#declare F_dull =
finish {
    ambient .2
    diffuse 1   
    phong .1
    phong_size 10  
}


#declare F_rubber =
finish {
    ambient .2
    diffuse 1   
    phong .3
    phong_size 5  
}


#declare F_flat =
finish {
    ambient 0
    diffuse 1   
    phong .1
    phong_size 20  
} 

#declare N_ripple_A = normal { bozo 0.2 scale 0.2 bump_size 2}  

#declare M_black_rubber =
material {
    texture {
       pigment { C_black }
       finish { F_rubber }
   }
}

#declare M_black_dull =
material {
    texture {
       pigment { C_black }
       finish { F_dull }
   }
}

#declare M_gray_dark_dull =
material {
    texture {
       pigment { C_gray_dark }
       finish { F_dull }
   }
}


#declare M_red_rubber =
material {
    texture {
       pigment { C_red }
       finish { F_rubber }
   }
}


#declare M_black_rubber_grip =
material {
    texture {
       pigment { C_gray_black    }
       finish  { F_rubber   }
       normal  { N_ripple_A }
   }
}   



// -----------------------------------------------------------------------------------------
//                      S T E E L
//------------------------------------------------------------------------------------------

#declare C_map_old_copper =
color_map {
    [ 0.0  C_copper *.83]  
    [ 0.3  C_copper *.83]
    [ 0.5  C_gray60 *.63]
    [ 0.8  C_copper *.63] 
    [ 1    C_copper *.83]
    }
        
#declare C_map_rust_gray = 
color_map {
    [0.0        C_rust_gray* .3]
    [0.1        C_rust_gray_dark * 1]
    [0.3        C_rust_gray_dark * 1] 
    [0.55       C_rust_gray * .5]
    [0.85       C_rust_gray * .3]
    [0.9        C_rust_gray_dark * 1]
    [1.000      C_rust_gray* .5]
}


#declare C_map_rust_red = 
color_map {
    [0.0        C_rust_gray ]
    [0.2        C_rust_red * .5]
    [0.25       C_rust_red * .7] 
    [0.4        C_rust_gray * 1]
    [0.85       C_rust_gray * 1.5]
    [0.9        C_rust_red * .6]
    [1.000      C_rust_gray]
}


#declare C_map_rust_overlay = 
color_map {
    [0.0        C_clear ]
    [0.2        C_rust_red ]
    [0.3        C_rust_red_film * .7] 
    [0.4        C_clear * 1]
    [0.85       C_clear * 1.5]
    [0.9        C_rust_red_film * .6]
    [1.000      C_clear]
}

#declare C_map_dirt_overlay = 
color_map {
    [0.0        C_clear ]
    [0.2        C_black ]
    [0.3        C_gray20 ] 
    [0.5        C_tan * .2]
    [0.85       C_clear ]
    [0.9        C_rust_red * .6]
    [1.000      C_black]
}



#declare C_map_rust_normal = 
color_map {
    [0.0        C_white ]
    [0.2        C_gray50 ]
    [0.3        C_gray70 ] 
    [0.4        C_white ]
    [0.85       C_white ]
    [0.9        C_gray50 ]
    [1.000      C_white ]
}

    
#declare C_map_dent_A = 
color_map {
    [0.0        C_white ]
    [0.2        C_gray50 ]
    [0.3        C_black ] 
    [0.4        C_black ]     
    [0.5        C_white ]
    [0.85       C_white ]
    [0.9        C_gray50 ]
    [1.000      C_white ]
}

#declare F_old_steel  =
finish {  
    reflection {.001, .2 fresnel on } 
    conserve_energy 
    brilliance 5
    ambient 0
    diffuse .8 
    metallic
    specular 3 
    roughness .1
    reflection .25 
}

//--- steel old
#declare sz = <.6,2,.6> ;   
#declare turb = 1.1; 
#declare bump = .03; 

#declare T_steel_old =
texture { 
    pigment { 
        spotted 
        color_map {C_map_rust_gray} 
        turbulence turb
        scale sz
        } 


    
    normal {
         crackle 
         turbulence turb 
         bump_size bump
         scale sz
     }   
 }



//--- steel old spotted
#declare sz = <1,1,1>*.5 ;   
#declare turb = 1.1; 
#declare bump = .2; 

#declare T_steel_spotted =
texture { 
    pigment { 
        spotted 
        color_map {C_map_rust_overlay} 
        turbulence turb
        scale sz
        } 

    finish{F_old_steel}
    
    normal {
        pigment_pattern{ 
            spotted 
            color_map {C_map_rust_normal} 
            turbulence turb
            scale sz
         }  
         bump_size bump
     }   
 }


#declare M_steel_aged_2 =
material {
   texture { T_steel_old        rotate <30,30,30> scale <3,3,3>}
   texture { T_steel_spotted    rotate <30,30,30> scale <3,2,3>}
}